<div x-data="{showModal:false}">
    <p x-tooltip.placement.bottom="'Click to View Details'" @click="showModal = true" class="text-slate-700 line-clamp-1 dark:text-navy-100">
        <b>REF:/<?php echo $trans['narration'] ?></b>
    </p>
    <template x-teleport="#trans-invoice">
        <div class="fixed inset-0 z-[100] flex flex-col items-center justify-center overflow-hidden px-2 py-2 sm:px-5" x-show="showModal" role="dialog" @keydown.window.escape="showModal = false">
            <div class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300" @click="showModal = false" x-show="showModal" x-transition:enter="ease-out" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="ease-in" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"></div>
            <div class="relative w-full max-w-lg origin-top rounded-lg bg-white transition-all duration-300 dark:bg-navy-700" x-show="showModal" x-transition:enter="easy-out" x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100" x-transition:leave="easy-in" x-transition:leave-start="opacity-100 scale-100" x-transition:leave-end="opacity-0 scale-95">
                <div class="flex justify-between rounded-t-lg bg-slate-200 px-1 py-1 dark:bg-navy-800 sm:px-5">
                    <button @click="showModal = !showModal" class="btn -mr-1.5 h-7 w-7 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4.5 w-4.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
                <div class="px-2 py-2 sm:px-5">
                    <div class="grid grid-cols-1">
                        <div class="card px-5 py-12 sm:px-18">
                            <div class="flex flex-col justify-between sm:flex-row">
                                <div class="text-center sm:text-left">
                                    <div class="space-y-1 pt-2">
                                        <p>Type: <span class="font-semibold"><?php echo $trans['trans_type'] ?></span></p>
                                        <p>
                                            Created: <span class="font-semibold"><?php echo date('d/M/Y \\a\\t h:i A', $date) ?></span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="my-7 h-px bg-slate-200 dark:bg-navy-500"></div>
                            <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
                                <table class="is-zebra w-full text-left">
                                    <thead>
                                        <tr>
                                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                                <?php echo $trans['mode'] ?>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>

                                            <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                                                <div>
                                                    <p class="font-medium text-slate-600 dark:text-navy-100">
                                                        <?php echo $trans['narration']; ?>
                                                    </p>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="my-2 h-px bg-slate-200 dark:bg-navy-500"></div>
                            <div class="flex flex-col justify-between sm:flex-row">
                                <div class="text-center sm:text-left">
                                    <p class="text-lg font-medium text-slate-600 dark:text-navy-100">
                                        Payment Method:
                                    </p>
                                    <div class="space-y-1 pt-2">
                                        <p class="font-medium"><?php echo $trans['mode']; ?></p>
                                    </div>
                                </div>
                                <div class="mt-4 text-center sm:mt-0 sm:text-right">
                                    <p class="text-lg font-medium text-slate-600 dark:text-navy-100">
                                        Total:
                                    </p>
                                    <div class="space-y-1 pt-2">
                                        <p>Summary : <span class="font-medium"><?php echo $currency . ' ' . number_format(($trans['balance'] - $trans['commission']), 2); ?></span></p>
                                        <p>Commission : <span class="font-medium"><?php echo $currency ?></span> <?php echo number_format($trans['commission'], 2) ?></p>
                                        <p>Tax : <span class="font-medium">0.0%</span></p>
                                        <p class="text-lg text-primary dark:text-accent-light">
                                            Total: <span class="font-medium"><?php echo $currency . " " . number_format($trans['balance'], 2); ?></span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </template>
</div>
<script>
    jQuery(document).ready(function() {
        Main.init();
        Login.init();
    });
</script>