            <div class="flex">
                <div x-data="{showModal:false}">
                    <button @click="showModal = true" class="badge mt-2 bg-info/10 text-info dark:bg-info/15">
                        <span class="text pr-1"> Click to transfer to <?php echo $siteName ?> </span>
                        <i class="fa fa-send"></i>
                    </button>
                    <template x-teleport="#mybank-transfer">
                        <div class="fixed inset-0 z-[100] flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5" x-show="showModal" role="dialog" @keydown.window.escape="showModal = false">
                            <div class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300" @click="showModal = false" x-show="showModal" x-transition:enter="ease-out" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="ease-in" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"></div>
                            <div class="relative w-full max-w-lg origin-top rounded-lg bg-white transition-all duration-300 dark:bg-navy-700" x-show="showModal" x-transition:enter="easy-out" x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100" x-transition:leave="easy-in" x-transition:leave-start="opacity-100 scale-100" x-transition:leave-end="opacity-0 scale-95">
                                <div class="flex justify-between rounded-t-lg bg-slate-200 px-4 py-3 dark:bg-navy-800 sm:px-5">
                                    <h3 class="text-base font-medium text-slate-700 dark:text-navy-100">
                                        Transfer to a <?php echo $siteName ?> account
                                    </h3>
                                    <button @click="showModal = !showModal" class="btn -mr-1.5 h-7 w-7 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4.5 w-4.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path>
                                        </svg>
                                    </button>
                                </div>
                                <div class="px-4 py-4 sm:px-5">
                                    <form action="../../bank-manager.php?action=send-money" onsubmit="return valid()" method="POST">
                                        <div class="flex items-center justify-between py-3">
                                            <h2 class="font-medium tracking-wide text-slate-700 dark:text-navy-100">
                                                Send Money
                                            </h2>
                                        </div>
                                        <div class="rounded-lg border border-slate-150 p-2 dark:border-navy-700">
                                            <div class="flex justify-between">
                                                <p class="text-xl font-semibold text-slate-700 dark:text-navy-100">
                                                    <?php echo $currency . " " . number_format($balance, 2) ?>
                                                </p>
                                                <span class="h-5 w-5 text-warning"><i class="fa fa-money"></i></span>
                                            </div>
                                            <p class="text-xs+ line-clamp-1">Current Balance</p>
                                        </div>
                                        <div class="mt-2 space-y-4">
                                            <label class="block">
                                                <span class="text-xs+">Account Number</span>
                                                <input onblur="userAvailabilityMb()" id="account_numberMb" name="receiver" required class="form-input mt-1.5 h-9 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent" placeholder="**** **** **** ****" type="text" />
                                            </label>
                                            <span class="text-center" id="account_name" style="font-size:12px;"></span>
                                            <div x-data="{config:{numeral: true, numeralThousandsGroupStyle: 'thousand'}}">
                                                <span class="text-xs+">Amount</span>
                                                <div class="mt-1.5 flex h-9 -space-x-px">
                                                    <select class="form-select rounded-l-lg border border-slate-300 bg-white px-3 py-2 pr-9 hover:z-10 hover:border-slate-400 focus:z-10 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent">
                                                        <option class="hover:bg-primary/20" x-tooltip.placement.right="'<?php echo $currency ?>'"><?php echo $currency ?></option>
                                                    </select>
                                                    <input required id="send-amount-mb" value="" x-input-mask="config" name="amount" onblur="amountInputMb()" class="form-input w-full rounded-r-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:z-10 hover:border-slate-400 focus:z-10 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent" placeholder="Amount" />
                                                </div>
                                            </div>
                                            <label class="block">
                                                <span>Narration:</span>
                                                <textarea required name="narration" rows="2" maxlength="70" placeholder="Transfer Narration" class="form-textarea mt-1.5 w-full resize-none rounded-lg border border-slate-300 bg-transparent p-2.5 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"></textarea>
                                            </label>
                                        </div>
                                        <label class="block">
                                            <span>4-Digit Pin</span>
                                            <input required class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent" placeholder="XXXX" type="password" pattern="[0-9]{4}" inputmode="numeric" maxlength="4" name="pin" />
                                        </label>
                                        <div class="mt-5 flex justify-between text-slate-400 dark:text-navy-300">
                                            <p class="text-xs+">Commission:</p>
                                            <p><?php echo $currency ?><span id="amountToPayMbCommission"></span></p>
                                        </div>
                                        <input type="hidden" name="transfer_type" value="MYBANK">
                                        <?php include("../components/userSendInfo.php") ?>
                                        <div class="mt-2 flex justify-between">
                                            <p>Total:</p>
                                            <span style="display:flex" class="font-medium text-slate-700 dark:text-navy-100">
                                                <span class="pr-1"><?php echo $currency ?> </span><span id="amountToPayMb"></span>
                                            </span>
                                        </div>
                                        <button id="account_namebutton" type="submit" class="btn mt-5 h-10 w-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
                                            Send Money
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                </div>
                </template>
            </div>
            </div>
            <script>
                jQuery(document).ready(function() {
                    Main.init();
                    Login.init();
                });
            </script>

            <script>
                function amountInputMb() {
                    document.getElementById("amountToPayMb").style.display = "none";
                    var payamountmb = $("#send-amount-mb").val();
                    var commission = 0.0005 * Number(payamountmb.replaceAll(",", ""));
                    payamountmb = Number(payamountmb.replaceAll(",", "")) + commission;
                    if (1 == 1) {
                        document.getElementById("amountToPayMb").style.display = "block";
                        $("#amountToPayMb").html(`${new Intl.NumberFormat().format(payamountmb)}`);
                        $("#amountToPayMbCommission").html(`${new Intl.NumberFormat().format(commission)}`);
                        $("#commission").value(commission);
                    }
                }
            </script>

            <script>
                function userAvailabilityMb() {
                    jQuery.ajax({
                        url: "check-account.php",
                        data: 'receiver=' + $("#account_numberMb").val(),
                        type: "POST",
                        success: function(data) {
                            $("#account_name").html(data);
                            $("#account_namebutton").html("Send to " + " " + "<i class='fa fa-send'></i>" + data);
                        },
                        error: function() {
                            $("#account_namebutton").html("Send Money");
                        }
                    });
                }
            </script>