<div class="flex">
  <div x-data="{showModal:false}">
    <button @click="showModal = true" class="btn space-x-2 rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
      <span> Pay </span>
      <i class="fa-solid fa-money-check-dollar"></i>
    </button>
    <template x-teleport="#paybill">
      <div class="fixed inset-0 z-[100] flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5" x-show="showModal" role="dialog" @keydown.window.escape="showModal = false">
        <div class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300" @click="showModal = false" x-show="showModal" x-transition:enter="ease-out" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="ease-in" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"></div>
        <div class="relative w-full max-w-lg origin-top rounded-lg bg-white transition-all duration-300 dark:bg-navy-700" x-show="showModal" x-transition:enter="easy-out" x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100" x-transition:leave="easy-in" x-transition:leave-start="opacity-100 scale-100" x-transition:leave-end="opacity-0 scale-95">
          <div class="flex justify-between rounded-t-lg bg-slate-200 px-4 py-3 dark:bg-navy-800 sm:px-5">
            <h3 class="text-base font-medium text-slate-700 dark:text-navy-100">
              Initiate A Bill Payment
            </h3>
            <button @click="showModal = !showModal" class="btn -mr-1.5 h-7 w-7 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25">
              <svg xmlns="http://www.w3.org/2000/svg" class="h-4.5 w-4.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path>
              </svg>
            </button>
          </div>
          <div class="px-4 py-4 sm:px-5">
            <form action="../../bank-manager.php?action=pay-bill" onsubmit="return valid()" method="POST" enctype="multipart/form-data">
              <div class="rounded-lg border border-slate-150 p-2 dark:border-navy-700">
                <div class="flex justify-between">
                  <p class="text-xl font-semibold text-slate-700 dark:text-navy-100">
                    <?php echo $currency . " " . number_format($balance, 2) ?>
                  </p>
                  <span class="h-5 w-5 text-warning"><i class="fa fa-money"></i></span>
                </div>
                <p class="text-xs+ line-clamp-1">Current Balance</p>
              </div>
              <div class="mt-2 space-y-4">
                <div class="grid w-full">
                  <label class="block">
                    <span>Bill Type</span>
                    <select name="category" required class="mt-1.5 w-full" x-init="$el._tom = new Tom($el,{create: true,sortField: {field: 'text',direction: 'asc'}})">
                      <option style="font-weight:bold;" value="Insurance">Insurance</option>
                      <option style="font-weight:bold;" value="Electricity">Electricity</option>
                      <option style="font-weight:bold;" value="Taxes & Levies">Taxes & Levies</option>
                      <option style="font-weight:bold;" value="Utility Bill">Utility Bill</option>
                      <option style="font-weight:bold;" value="Transport">Transport</option>
                      <option style="font-weight:bold;" value="Cable TV">Cable TV</option>
                      <option style="font-weight:bold;" value="Tuition Deposit">Tuition Deposit</option>
                      <option style="font-weight:bold;" value="Hotel">Hotel</option>
                    </select>
                  </label>
                </div>
                <div class="grid w-full">
                  <label class="block">
                    <span class="text-xs+">Biller Name</span>
                    <input class="mt-1.5 w-full" x-init="$el._tom = new Tom($el,{create:true,plugins: ['caret_position','input_autogrow']})" placeholder="Biller's Name" type="text" name="company" />
                  </label>
                </div>
                <div class="grid w-full grid-cols-2 gap-2">
                  <label class="block">
                    <span class="text-xs+">Biller Account Number</span>
                    <input x-input-mask="{ creditCard: true}" class="form-input mt-1.5 h-9 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent" placeholder="**** **** **** ****" type="text" name="company_account" />
                  </label>
                  <div x-data="{config:{numeral: true,numeralThousandsGroupStyle: 'thousand'}}">
                    <span class="text-xs+">Amount</span>
                    <div class="mt-1.5 flex h-9 -space-x-px">
                      <select class="form-select rounded-l-lg border border-slate-300 bg-white px-3 py-2 pr-9 hover:z-10 hover:border-slate-400 focus:z-10 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent">
                        <option class="hover:bg-primary/20" x-tooltip.placement.right="'<?php echo $curreny ?>'"><?php echo $currency ?></option>
                      </select>
                      <input id="send-amount" value="" x-input-mask="config" name="amount" onblur="amountInput()" class="form-input w-full rounded-r-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:z-10 hover:border-slate-400 focus:z-10 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent" placeholder="Amount" />
                    </div>
                  </div>
                  <?php include("../components/userSendInfo.php") ?>
                </div>
                <label class="block">
                  <span>4-Digit Pin</span>
                  <input required class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent" placeholder="XXXX" type="password" pattern="[0-9]{4}" inputmode="numeric" maxlength="4" name="pin" />
                </label>
              </div>

              <button id="submit" style="max-width:fit-content" class="btn mt-8 h-10 w-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
                Pay Bill
              </button>
            </form>
          </div>
        </div>
      </div>
  </div>
  </template>
</div>
</div>

<script>
  jQuery(document).ready(function() {
    Main.init();
    Login.init();
  });
</script>

<script>
  function amountInput() {
    document.getElementById("amountToPay").style.display = "none";
    var payamount = $("#send-amount").val();
    payamount = Number(payamount.replaceAll(",", "")) + 21;
    if (1 == 1) {
      document.getElementById("amountToPay").style.display = "block";
      $("#amountToPay").html(`${new Intl.NumberFormat().format(payamount)}`);
    }
  }
</script>