<div x-data="{showModal:false}">
    <?php include("./message-card.php") ?>
    <template x-teleport="#message-preview">
        <div class="fixed inset-0 z-[100] flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5" x-show="showModal" role="dialog" @keydown.window.escape="showModal = false">
            <div class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300" @click="showModal = false" x-show="showModal" x-transition:enter="ease-out" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="ease-in" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"></div>
            <div class="relative max-w-md rounded-lg bg-white pt-10 pb-4 text-center transition-all duration-300 dark:bg-navy-700" x-show="showModal" x-transition:enter="easy-out" x-transition:enter-start="opacity-0 [transform:translate3d(0,1rem,0)]" x-transition:enter-end="opacity-100 [transform:translate3d(0,0,0)]" x-transition:leave="easy-in" x-transition:leave-start="opacity-100 [transform:translate3d(0,0,0)]" x-transition:leave-end="opacity-0 [transform:translate3d(0,1rem,0)]">
                <h3 class="mt-4 px-4 text-lg text-slate-800 dark:text-navy-50">
                    <?php echo $noti['title']; ?>
                </h3>
                <div class="space-y-1 pt-2">
                    <p>Sender: <span class="font-semibold"><?php echo $noti['sender']; ?> (<?php echo $noti['role']; ?>)</span></p>
                    <p>
                        Date: <span class="font-semibold"><?php echo date('d/M/Y \\a\\t h:i A', $date) ?></span>
                    </p>
                </div>
                <div class="mt-4 px-4 sm:px-12">
                    <p class="mt-1 text-slate-500 dark:text-navy-200">
                        <?php echo $noti['message']; ?>
                    </p>
                </div>
                <div class="my-4 mt-16 h-px bg-slate-200 dark:bg-navy-500"></div>

                <div class="space-x-3">
                    <form style="float:left" action="../../bank-manager.php?action=userread-notification" method="post">
                        <input type="hidden" name="id" value="<?php echo $noti['id']; ?>">
                        <button style="float:left" @click="showModal = false" class="btn min-w-[7rem] rounded-full h-9 w-9 p-0 font-medium text-error hover:bg-error/20 focus:bg-error/20 active:bg-error/25">
                            <i class="fa-sharp fa-solid fa-circle-xmark"></i>
                            <span class="m-2">Close</span>
                        </button>
                    </form>
                    <form style="float:right" action="../../bank-manager.php?action=userdelete-notification" method="post">
                        <input type="hidden" name="id" value="<?php echo $noti['id']; ?>">
                        <button class="btn min-w-[7rem] rounded-full h-9 w-9 p-0 font-medium text-error hover:bg-error/20 focus:bg-error/20 active:bg-error/25">
                            <span class="m-2">Delete</span>
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                            </svg>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </template>
</div>