<div class="card group col-span-12 pb-5 lg:col-span-6">
   <div class="my-3 flex flex-col justify-between px-4 sm:flex-row sm:items-center sm:px-5">
      <div class="flex flex-1 items-center justify-between space-x-2 sm:flex-initial">
         <h2 class="text-sm+ font-medium tracking-wide text-slate-700 dark:text-navy-100">
            Transaction History
         </h2>
         <div x-data="usePopper({placement:'bottom-start',offset:4})" @click.outside="isShowPopper && (isShowPopper = false)" :class="!isShowPopper && 'sm:opacity-0'" class="inline-flex focus-within:opacity-100 group-hover:opacity-100">
            <button x-ref="popperRef" @click="isShowPopper = !isShowPopper" class="btn h-8 w-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25">
               <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 12h.01M12 12h.01M19 12h.01M6 12a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0z" />
               </svg>
            </button>

            <div x-ref="popperRoot" class="popper-root" :class="isShowPopper && 'show'">
               <div class="popper-box rounded-md border border-slate-150 bg-white py-1.5 font-inter dark:border-navy-500 dark:bg-navy-700">
                  <ul>
                     <li>
                        <a href="../pay-bills/" class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-none transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100">Bills Payment</a>
                     </li>
                     <li>
                        <a href="../send-money/" class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-none transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100">Transfer Out</a>
                     </li>
                     <li>
                        <a href="../deposit-check/" class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-none transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100">Credit/Deposits</a>
                     </li>
                  </ul>
                  <div class="my-1 h-px bg-slate-150 dark:bg-navy-500"></div>
               </div>
            </div>
         </div>
      </div>
   </div>

   <div class="grid grid-cols-12 gap-4 px-4 sm:gap-5 sm:px-5 lg:gap-6 lg:px-5">
      <div class="col-span-12 rounded-lg bg-slate-50 p-3 dark:bg-navy-600 ">
         <div class="space-y-4">
            <?php
            include("../../includes/database.php");
            $transQuery = "SELECT * FROM transactions WHERE username='$username' ORDER BY date DESC limit 5";
            $outcome = mysqli_query($con, $transQuery) or die(mysqli_connect_error());

            if (mysqli_num_rows($outcome) < 5) {
               include("../components/profile-pan.php");
            } else {
               while ($trans = mysqli_fetch_assoc($outcome)) {

                  $input = $trans['date'];
                  $date = strtotime($input);

                  if ($trans['trans_type'] == 'Credit' || $trans['trans_type'] == 'Deposit') { ?>
                     <div class="flex cursor-pointer items-center justify-between">
                        <div class="flex items-center space-x-3">
                           <div class="avatar h-12 w-12">
                              <div class="is-initial rounded-lg bg-success/10 text-base uppercase text-success">
                                 CR
                              </div>
                           </div>
                           <div>
                              <?php include('../transactions/trans-invoice.php'); ?>
                              <p class="text-xs text-slate-400 line-clamp-1 dark:text-navy-200">
                                 <?php echo $trans['mode'] . " - " . date('d/M/Y \\a\\t h:i A', $date) ?>
                              </p>
                           </div>
                        </div>
                        <p class="font-medium text-success"><?php echo $currency . '' . number_format($trans['balance'], 2) ?></p>
                     </div>
                  <?php } else { ?>
                     <div class="flex cursor-pointer items-center justify-between">
                        <div class="flex items-center space-x-3">
                           <div class="avatar h-12 w-12">
                              <div class="is-initial rounded-lg bg-error/10 text-base uppercase text-error">
                                 DB
                              </div>
                           </div>
                           <div>
                              <?php require('../transactions/trans-invoice.php') ?>
                              <p class="text-xs text-slate-400 line-clamp-1 dark:text-navy-200">
                                 <?php echo $trans['mode'] . " - " . date('d/M/Y \\a\\t h:i A', $date) ?>
                              </p>
                           </div>
                        </div>
                        <p class="font-medium text-error"><?php echo $currency . '' . number_format($trans['balance'], 2) ?></p>
                     </div>
            <?php }
               }
            } ?>
         </div>
      </div>
   </div>
</div>