<div class="sidebar-panel">
  <div class="flex h-full grow flex-col bg-white pl-[var(--main-sidebar-width)] dark:bg-navy-750">
    <!-- Sidebar Panel Header -->
    <div class="flex h-18 w-full items-center justify-between pl-4 pr-1">
      <p class="text-base tracking-wider text-slate-800 dark:text-navy-100">
        <?php echo ucfirst($fname . " " . $lname) ?>
        <br>
        <small style="font-size:10px"><b>Account Number: </b> <?php echo ($account_number) ?></small>
      </p>

      <button @click="$store.global.isSidebarExpanded = false" class="btn h-7 w-7 rounded-full p-0 text-primary hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:text-accent-light/80 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25 xl:hidden">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
        </svg>
      </button>
    </div>

    <!-- Sidebar Panel Body -->
    <div x-data="{expandedItem:'menu-item-3'}" class="h-[calc(100%-4.5rem)] overflow-x-hidden pb-6" x-init="$el._x_simplebar = new SimpleBar($el);">
      <ul class="flex flex-1 flex-col px-4 font-inter">
        <li>
          <a x-data="navLink" href="../dashboard/" :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs+ tracking-wide outline-none transition-colors duration-300 ease-in-out">
            <b>Dashboard</b>
          </a>
        </li>
      </ul>
      <div class="my-3 mx-4 h-px bg-slate-200 dark:bg-navy-500"></div>
      <ul class="flex flex-1 flex-col px-4 font-inter">
        <li x-data="accordionItem('menu-item-1')">
          <a :class="expanded ? 'text-slate-800 font-semibold dark:text-navy-50' : 'text-slate-600 dark:text-navy-200  hover:text-slate-800  dark:hover:text-navy-50'" @click="expanded = !expanded" class="flex items-center justify-between py-2 text-xs+ tracking-wide outline-none transition-[color,padding-left] duration-300 ease-in-out" href="javascript:void(0);">
            <span>
              <span class="badge bg-slate-150 text-slate-800 space-x-2 dark:bg-navy-500 dark:text-navy-100">
                <i class="fa fa-send"></i>
              </span>
              Send Money
            </span>
            <svg :class="expanded && 'rotate-90'" xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-slate-400 transition-transform ease-in-out" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
            </svg>
          </a>
          <ul x-collapse x-show="expanded">
            <li>
              <a x-data="navLink" href="../send-money/" :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex items-center justify-between p-2 text-xs+ tracking-wide outline-none transition-[color,padding-left] duration-300 ease-in-out hover:pl-4">
                <div class="flex items-center space-x-2">
                  <div class="h-1.5 w-1.5 rounded-full border border-current opacity-40"></div>
                  <span><?php echo $siteNameShort ?> Bank TF </span>
                </div>
              </a>
            </li>
            <li>
              <a x-data="navLink" href="../send-money/" :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex items-center justify-between p-2 text-xs+ tracking-wide outline-none transition-[color,padding-left] duration-300 ease-in-out hover:pl-4">
                <div class="flex items-center space-x-2">
                  <div class="h-1.5 w-1.5 rounded-full border border-current opacity-40"></div>
                  <span>Other Bank TF</span>
                </div>
              </a>
            </li>
            <li>
              <a x-data="navLink" href="../send-money/" :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex items-center justify-between p-2 text-xs+ tracking-wide outline-none transition-[color,padding-left] duration-300 ease-in-out hover:pl-4">
                <div class="flex items-center space-x-2">
                  <div class="h-1.5 w-1.5 rounded-full border border-current opacity-40"></div>
                  <span>International Wire-TF</span>
                </div>
              </a>
            </li>
          </ul>
        </li>

        <li>
          <a x-data="navLink" href="../transactions/" :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs+ tracking-wide outline-none transition-colors duration-300 ease-in-out">
            <span>
              <span class="badge bg-slate-150 text-slate-800 space-x-2 dark:bg-navy-500 dark:text-navy-100">
                <i class="fa fa-history"> </i>
              </span>
              Transaction History
            </span>
          </a>
        </li>
        <li>
          <a x-data="navLink" href="../pay-bills/" :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs+ tracking-wide outline-none transition-colors duration-300 ease-in-out">
            <span>
              <span class="badge bg-slate-150 text-slate-800 space-x-2 dark:bg-navy-500 dark:text-navy-100">
                <i class="fa fa-file-text-o"> </i>
              </span>
              Pay Bills
            </span>
          </a>
        </li>
        <li>
          <a x-data="navLink" href="../beneficiaries/" :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs+ tracking-wide outline-none transition-colors duration-300 ease-in-out">
            <span>
              <span class="badge bg-slate-150 text-slate-800 space-x-2 dark:bg-navy-500 dark:text-navy-100">
                <i class="fa fa-users"> </i>
              </span>
              Beneficiary List
            </span>
          </a>
        </li>
      </ul>
      <div class="my-3 mx-4 h-px bg-slate-200 dark:bg-navy-500"></div>
      <ul class="flex flex-1 flex-col px-4 font-inter">
        <li>
          <a x-data="navLink" href="../deposit-check/" :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs+ tracking-wide outline-none transition-colors duration-300 ease-in-out">
            <span>
              <span class="badge bg-slate-150 text-slate-800 space-x-2 dark:bg-navy-500 dark:text-navy-100">
                <i class="fa fa-share-square"> </i>
              </span>
              Check Deposit
            </span>
          </a>
        </li>
        <li>
          <a x-data="navLink" href="../bitcoin-services" :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs+ tracking-wide outline-none transition-colors duration-300 ease-in-out">
            <span>
              <span class="badge bg-slate-150 text-slate-800 space-x-2 dark:bg-navy-500 dark:text-navy-100">
                <i class="fa fa-bitcoin"> </i>
              </span>
              Bitcoin Services
            </span>
          </a>
        </li>

        <li>
          <a x-data="navLink" href="../loans" :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs+ tracking-wide outline-none transition-colors duration-300 ease-in-out">
            <span>
              <span class="badge bg-slate-150 text-slate-800 space-x-2 dark:bg-navy-500 dark:text-navy-100">
                <i class="fa fa-money"> </i>
              </span>
              Loans
            </span>
          </a>
        </li>
      </ul>
      <div class="my-3 mx-4 h-px bg-slate-200 dark:bg-navy-500"></div>
      <ul class="flex flex-1 flex-col px-4 font-inter">
        <li>
          <a x-data="navLink" href="../card-management/" :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs+ tracking-wide outline-none transition-colors duration-300 ease-in-out">
            <span>
              <span class="badge bg-slate-150 text-slate-800 space-x-2 dark:bg-navy-500 dark:text-navy-100">
                <i class="fa fa-cc-visa"> </i>
              </span>
              Card Management
            </span>
          </a>
        </li>
        <li>
          <a x-data="navLink" href="../investment-brokerage/" :class="isActive ? 'font-medium text-primary dark:text-accent-light' : 'text-slate-600 hover:text-slate-900 dark:text-navy-200 dark:hover:text-navy-50'" class="flex py-2 text-xs+ tracking-wide outline-none transition-colors duration-300 ease-in-out">
            <span>
              <span class="badge bg-slate-150 text-slate-800 space-x-2 dark:bg-navy-500 dark:text-navy-100">
                <i class="fa fa-line-chart"> </i>
              </span>
              Investment Brokerage
            </span>
          </a>
        </li>
      </ul>
    </div>
  </div>
</div>
</div>