<div class="col-span-12 grid grid-cols-12 rounded-lg bg-gradient-to-r from-blue-500 to-indigo-600 py-5 sm:py-6">
  <div class="col-span-12 sm:col-span-6 lg:col-span-4">
    <div class="px-4 text-white sm:px-5">
      <div class="-mt-1 flex items-center space-x-2">
        <h2 class="text-base font-medium tracking-wide">Balance</h2>
        <div x-data="usePopper({placement:'bottom-end',offset:4})" @click.outside="isShowPopper && (isShowPopper = false)" class="inline-flex">
          <button x-ref="popperRef" @click="isShowPopper = !isShowPopper" class="btn h-8 w-8 rounded-full p-0 hover:bg-white/20 focus:bg-white/20 active:bg-white/25">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
              <path stroke-linecap="round" stroke-linejoin="round" d="M5 12h.01M12 12h.01M19 12h.01M6 12a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0z" />
            </svg>
          </button>

          <div x-ref="popperRoot" class="popper-root" :class="isShowPopper && 'show'">
            <div class="popper-box rounded-md border border-slate-150 bg-white py-1.5 font-inter dark:border-navy-500 dark:bg-navy-700">
              <ul>
                <li>
                  <a href="../send-money" class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-none transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100">Send Money</a>
                </li>
                <li>
                  <a href="../pay-bills" class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-none transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100">Pay Bill</a>
                </li>
                <li>
                  <a href="../deposit-check" class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-none transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100">Submit A Check</a>
                </li>
              </ul>
              <div class="my-1 h-px bg-slate-150 dark:bg-navy-500"></div>
            </div>
          </div>
        </div>
      </div>
      <div class="mt-3">
        <p class="text-2xl font-semibold"><?php echo $currency . " " . number_format($balance, 2) ?></p>
        <p class="text-base font-medium">Book Balance: <b> <?php echo $currency . " " . number_format($balance - 21, 2) ?></b></p>
      </div>
      <!-- <hr class="mt-3"> -->
      <div class="mt-4 flex space-x-7">
        <div>
          <p class="text-indigo-100"><b>Money In</b></p>
          <div class="mt-1 flex items-center space-x-2">
            <div class="flex h-7 w-7 items-center justify-center rounded-full bg-black/20">
              <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 11l5-5m0 0l5 5m-5-5v12" />
              </svg>
            </div>
            <p class="text-base font-medium">$ 2,225.22</p>
          </div>
        </div>
        <div>
          <p style="color:red" class="text-indigo-100 text-error"><b>Money Out</b></p>
          <div class="mt-1 flex items-center space-x-2">
            <div class="flex h-7 w-7 items-center justify-center rounded-full bg-black/20">
              <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 13l-5 5m0 0l-5-5m5 5V6" />
              </svg>
            </div>
            <p class="text-base font-medium">$ 225.22</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>