<?php 
include('../components/pages.head.php'); 

session_start();
if (isset($_SESSION['message']) != "") {
    $loginMessage = $_SESSION['message'];
 } else {
    $loginMessage = "";
 }
?>

<body>
    <?php include('../components/pages.header.php'); ?>
    
    <main>
        <!-- Breadcrumbs S t a r t -->
        <section class="breadcrumbs-area breadcrumb-bg">
            <div class="container">
                <h1 class="title wow fadeInUp" data-wow-delay="0.0s">Login to your <?php echo $siteNameShort ?> Account </php></h1>
            </div>

        </section>
        <!--/ End-of Breadcrumbs-->

        <!-- Login area S t a r t  -->
        <div class="login-area section-padding">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-5 col-lg-6 col-md-8 col-sm-10">
                        <div class="login-card">
                            <!-- Logo -->
                            <div class="logo mb-40">
                                <a href="/" class="mb-30 d-block">
                                    <img style="width: 180px;" src="../assets/images/logo/logo.png" alt="logo" class="changeLogo">
                                </a>
                            </div>
                            <!-- Form -->
                            <form action="../bank-manager.php?action=user-login"  method="POST">
                                <div class="mb-2" style="color:red; text-align:center" id=""><?php echo $loginMessage ?></div>
                                <div class="position-relative contact-form mb-24">
                                    <label class="contact-label">Username or Account Number </label>
                                    <input required name="username" class="form-control contact-input" type="text"
                                        placeholder="Account Number or Username">
                                </div>

                                <div class="contact-form mb-24">
                                    <div class="position-relative ">
                                        <div class="d-flex justify-content-between aligin-items-center">
                                            <label class="contact-label">Password</label>
                                            <a href="../contact-us"><span class="text-primary text-15"> Forgot
                                                    password? </span></a>
                                        </div>
                                        <input required name="password"  type="password" class="form-control contact-input password-input"
                                            id="txtPasswordLogin" placeholder="Enter Password">
                                        <i class="toggle-password ri-eye-line"></i>
                                    </div>
                                </div>

                                <button type="submit" class="btn-primary-fill justify-content-center w-100">
                                    <span class="d-flex justify-content-center gap-6">
                                        <span>Login</span>
                                    </span>
                                </button>
                            </form>

                            <div class="login-footer">
                                <div class="create-account">
                                    <p>
                                        Don’t have an account?
                                        <a href="../register">
                                            <span class="text-primary">Register</span>
                                        </a>
                                    </p>
                                </div>
                                <a href="#GoogleLogin"
                                    class="login-btn d-flex align-items-center justify-content-center gap-10">
                                    <img src="../assets/images/icon/google-icon.png" alt="img" class="m-0">
                                    <span> login with Google</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--/ End-of Login -->
    </main>

   <?php
   unset($_SESSION['message']);
   include('../components/pages.footer.php'); 
   ?>