<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="x-apple-disable-message-reformatting">
  <title></title>

  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@300;400;500;600;700&display=swap" rel="stylesheet">

  <style>
    html,
    body {
      margin: 0 auto !important;
      padding: 0 !important;
      height: 100% !important;
      width: 100% !important;
      font-family: 'Quicksand', sans-serif !important;
      font-size: 14px;
      margin-bottom: 10px;
      line-height: 24px;
      color: #8094ae;
      font-weight: 400;
    }

    * {
      -ms-text-size-adjust: 100%;
      -webkit-text-size-adjust: 100%;
      margin: 0;
      padding: 0;
    }

    table {
      border-spacing: 0 !important;
      border-collapse: collapse !important;
      table-layout: fixed !important;
      margin: 0 auto !important;
    }

    table table table {
      table-layout: auto;
    }

    a {
      text-decoration: none;
    }

    img {
      -ms-interpolation-mode: bicubic;
    }





    /* -------------------------------------
            INVOICE
        ------------------------------------- */
    .invoice {
      margin: 40px auto;
      text-align: left;
      width: 80%;
    }

    .invoice td {
      padding: 5px 0;
    }

    .invoice .invoice-items {
      width: 100%;
    }

    .invoice .invoice-items td {
      border-top: #eee 1px solid;
    }

    .invoice .invoice-items .total td {
      border-top: 2px solid #333;
      border-bottom: 2px solid #333;
      font-weight: 700;
    }


    .content {
      max-width: 600px;
      margin: 0 auto;
      display: block;
      padding: 20px;
    }

    /* -------------------------------------
            HEADER, FOOTER, MAIN
        ------------------------------------- */
    .main {
      background: #fff;
      border: 1px solid #e9e9e9;
      border-radius: 3px;
    }

    .content-wrap {
      padding: 20px;
    }

    .content-block {
      padding: 0 0 20px;
    }

    .aligncenter {
      text-align: center;
    }

    .alignright {
      text-align: right;
    }

    .alignleft {
      text-align: left;
    }
  </style>

</head>

<body width="100%" style="margin: 0; padding: 0 !important; background-color: #f5f6fa;">
  <span style="width: 100%; background-color: #f5f6fa;">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" bgcolor="#f5f6fa">
      <tr>
        <td style="padding: 40px 0;">
          <table style="width:100%;max-width:620px;margin:0 auto;">
            <tbody>
              <tr>
                <td style="text-align: center; padding-bottom:25px">
                  <a href="#"><img style="height: 40px" src="https://{{siteDomain}}/assets/images/logo/logo-mail.png" alt="logo"></a>
                  <p style="font-size: 14px; color: #02165a; padding-top: 18px;">Transfer Successful</p>
                </td>
              </tr>
            </tbody>
          </table>
          <table style="width:100%;max-width:620px;margin:0 auto;background-color:#ffffff;">
            <td class="content-wrap aligncenter">
              <table width="100%" cellpadding="0" cellspacing="0">
                <tr>
                  <td class="content-block">
                    <h2>Hello {{fullname}}</h2>
                    <p>This is a transaction reciept from your account</p>
                  </td>
                </tr>
                <tr>
                  <td class="content-block">
                    <table class="invoice">
                      <tr>
                        <td><b>Account Number:</b> {{account_number}}<br>
                          <br><b>Date:</b> {{date}}
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <table class="invoice-items" cellpadding="0" cellspacing="0">
                            <tr>
                              <td>Type</td>
                              <td class="alignright"> <b>DEBIT</b></td>
                            </tr>
                            <tr>
                              <td>Amount</td>
                              <td class="alignright">{{currency}} {{amount}}</td>
                            </tr>
                            <tr>
                              <td>Narration</td>
                              <td class="alignright">{{narration}}</td>
                            </tr>
                            <tr class="total">
                              <td class="alignright" width="80%">Current Balance</td>
                              <td class="alignright">{{currency}} {{current_balance}}</td>
                            </tr>
                          </table>
                        </td>
                      </tr>
                    </table>
                  </td>
                </tr>
                <tr>
                  <td class="content-block">
                    <h2>Thanks for using {{siteName}}</h2>
                  </td>
                </tr>
              </table>
              <table style="width:100%;max-width:620px;margin:0 auto;">
                <tbody>
                  <tr>
                    <td style="text-align: center; padding:25px 20px 0;">
                      <p style="font-size: 13px;">Copyright <?php echo date('Y'); ?> {{siteName}}. All rights reserved. <br></p>

                      <p style="padding-top: 15px; font-size: 12px;">This email was sent to you as a registered user of <a style="color: #02165a; text-decoration:none;" href="https://{{siteDomain}}">{{siteDomain}}</a>. To update your emails preferences <a style="color: #02165a; text-decoration:none;" href="#">click here</a>.</p>
                    </td>
                  </tr>
                </tbody>
              </table>
            </td>
      </tr>
    </table>
  </span>
</body>

</html>