<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="x-apple-disable-message-reformatting">
    <title></title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        html,
        body {
            margin: 0 auto !important;
            padding: 0 !important;
            height: 100% !important;
            width: 100% !important;
            font-family: 'Quicksand', sans-serif !important;
            font-size: 14px;
            margin-bottom: 10px;
            line-height: 24px;
            color: #8094ae;
            font-weight: 400;
        }

        * {
            -ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%;
            margin: 0;
            padding: 0;
        }

        table {
            border-spacing: 0 !important;
            border-collapse: collapse !important;
            table-layout: fixed !important;
            margin: 0 auto !important;
        }

        table table table {
            table-layout: auto;
        }

        a {
            text-decoration: none;
        }

        img {
            -ms-interpolation-mode: bicubic;
        }
    </style>

</head>

<body width="100%" style="margin: 0; padding: 0 !important; background-color: #f5f6fa;">
    <span style="width: 100%; background-color: #f5f6fa;">
        <table width="100%" border="0" cellpadding="0" cellspacing="0" bgcolor="#f5f6fa">
            <tr>
                <td style="padding: 40px 0;">
                    <table style="width:100%;max-width:620px;margin:0 auto;">
                        <tbody>
                            <tr>
                                <td style="text-align: center; padding-bottom:25px">
                                    <a href="#"><img style="height: 40px" src="https://{{siteDomain}}/assets/images/logo/logo-mail.png" alt="logo"></a>
                                    <p style="font-size: 14px; color: #02165a; padding-top: 12px;">{{siteName}}</p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <table style="width:100%;max-width:620px;margin:0 auto;background-color:#ffffff;">
                        <tbody>
                            <tr>
                                <td style="text-align:left;padding: 30px 30px 15px 30px;">
                                    <h2 style="font-size: 18px; color: #02165a; font-weight: 600; margin: 0;">{{type}} Code Alert</h2>
                                    <p>You have a transaction notification on your {{siteName}} account</p>
                                </td>
                            </tr>
                            <tr>
                                <td style="text-align:left;padding: 0 30px 20px">
                                    <p style="margin-bottom: 10px;">Hi {{fullname}},</p>
                                    <p style="margin-bottom: 25px; text-align:justify;">
                                        {{siteName}} writes to inform you that your account with the Account Number: <b>{{account_number}}</b> initiated a transfer.
                                    </p>
                                    <p>
                                        Your {{type}} - ({{codeName}}) is as follows:
                                        <a href="#" style="background-color:#02165a;border-radius:4px;color:#ffffff;display:inline-block;font-size:13px;font-weight:600;line-height:44px;text-align:center;text-decoration:none;text-transform: none; padding: 0 25px">
                                            <b>{{code}}</b>
                                        </a>
                                    </p>
                                    <p style="margin-top:10px;">
                                        You can proceed to complete your transfer. Be rest assured that the privacy and security of your Bank account 
                                        details is important to us.
                                    </p>
                          
                                    <p style="margin-top:10px; margin-bottom: 15px; text-align:justify;">
                                        From All of us at {{siteName}},
                                        We say Happy Banking.
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td style="text-align:center;padding: 20px 30px 40px">
                                    <p>If you did not make this request, please contact us or ignore this message.</p>
                                    <p style="margin: 0; font-size: 10px; color:#9ea8bb;">This is an automatically generated email please do not reply to this email. If you face any issues, please contact us at info@{{siteDomain}}</p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <table style="width:100%;max-width:620px;margin:0 auto;">
                        <tbody>
                            <tr>
                                <td style="text-align: center; padding:25px 20px 0;">
                                    <p style="font-size: 13px;">Copyright <?php echo date('Y'); ?> {{siteName}}. All rights reserved. <br></p>

                                    <p style="padding-top: 15px; font-size: 12px;">
                                        This email was sent to you as a registered user of
                                        <a style="color: #02165a; text-decoration:none;" href="https://{{siteDomain}}">{{siteDomain}}</a>.
                                        To update your emails preferences
                                        <a style="color: #02165a; text-decoration:none;" href="#">click here</a>.
                                    </p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </table>
    </span>
</body>

</html>